/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#include <stdio.h>
#include <string.h>

#include <csl_intc.h>

#include "swi.h"
//#include "omaptypes.h"

int
enable_global_interrupt()
{
    CSL_IntcDispatcherContext intcDispatcherContext;
    CSL_IntcContext intcContext;
    CSL_IntcEventEnableState intcState;

    memset(&intcDispatcherContext, 0, sizeof(CSL_IntcDispatcherContext));
    memset(&intcContext, 0, sizeof(CSL_IntcContext));

    SWI_sysMode();

    /* Interrupt Initializtion */
    CSL_intcInit(&intcContext);
    CSL_intcDispatcherInit(&intcDispatcherContext);
    CSL_intcGlobalEnable(&intcState);

    printf("Enable Gloable Interrupt !\n");

    return 0;
}
